/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import java.util.Random;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.world.biome.LOTRBiomeGenFangorn;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.ForgeHooks;

public abstract class LOTREntityTree
extends LOTREntityNPC {
    public static Block[] WOOD_BLOCKS = new Block[]{Blocks.field_150364_r, LOTRMod.wood2, Blocks.field_150364_r};
    public static Block[] LEAF_BLOCKS = new Block[]{Blocks.field_150362_t, LOTRMod.leaves2, Blocks.field_150362_t};
    public static Block[] SAPLING_BLOCKS = new Block[]{Blocks.field_150345_g, LOTRMod.sapling2, Blocks.field_150345_g};
    public static int[] WOOD_META = new int[]{0, 1, 2};
    public static int[] LEAF_META = new int[]{0, 1, 2};
    public static int[] SAPLING_META = new int[]{0, 1, 2};
    public static String[] TYPES = new String[]{"oak", "beech", "birch"};

    public LOTREntityTree(World world) {
        super(world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)0);
        if (this.field_70146_Z.nextInt(9) == 0) {
            this.setTreeType(2);
        } else if (this.field_70146_Z.nextInt(3) == 0) {
            this.setTreeType(1);
        } else {
            this.setTreeType(0);
        }
    }

    public int getTreeType() {
        byte i = this.field_70180_af.func_75683_a(16);
        if (i < 0 || i >= TYPES.length) {
            i = 0;
        }
        return i;
    }

    public void setTreeType(int i) {
        this.field_70180_af.func_75692_b(16, (Object)((byte)i));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("EntType", (byte)this.getTreeType());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setTreeType(nbt.func_74771_c("EntType"));
    }

    @Override
    public void func_70624_b(EntityLivingBase target) {
        if (target instanceof LOTREntityTree) {
            return;
        }
        super.func_70624_b(target);
    }

    public void func_70653_a(Entity entity, float f, double d, double d1) {
        super.func_70653_a(entity, f, d, d1);
        this.field_70159_w /= 2.0;
        this.field_70181_x /= 2.0;
        this.field_70179_y /= 2.0;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float f) {
        if (this.doTreeDamageCalculation() && !this.isTreeEffectiveDamage(damagesource)) {
            f /= 3.0f;
        }
        return super.func_70097_a(damagesource, f);
    }

    protected boolean doTreeDamageCalculation() {
        return true;
    }

    protected final boolean isTreeEffectiveDamage(DamageSource damagesource) {
        ItemStack itemstack;
        if (damagesource.func_76347_k()) {
            return true;
        }
        return damagesource.func_76346_g() instanceof EntityLivingBase && damagesource.func_76364_f() == damagesource.func_76346_g() && (itemstack = ((EntityLivingBase)damagesource.func_76346_g()).func_70694_bm()) != null && ForgeHooks.canToolHarvestBlock((Block)Blocks.field_150364_r, (int)0, (ItemStack)itemstack);
    }

    public void func_70690_d(PotionEffect effect) {
        if (effect.func_76456_a() == Potion.field_76436_u.field_76415_H) {
            return;
        }
        super.func_70690_d(effect);
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        int logs = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)3, (int)10) + this.field_70146_Z.nextInt(4 * (i + 1));
        for (int l = 0; l < logs; ++l) {
            int treeType = this.getTreeType();
            this.func_70099_a(new ItemStack(WOOD_BLOCKS[treeType], 1, WOOD_META[treeType]), 0.0f);
        }
        int sticks = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)6, (int)16) + this.field_70146_Z.nextInt(5 * (i + 1));
        for (int l = 0; l < sticks; ++l) {
            this.func_145779_a(Items.field_151055_y, 1);
        }
    }

    @Override
    public boolean canDropRares() {
        return false;
    }

    @Override
    public boolean func_70601_bi() {
        if (super.func_70601_bi()) {
            if (this.liftSpawnRestrictions) {
                return true;
            }
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            Block block = this.field_70170_p.func_147439_a(i, j - 1, k);
            this.field_70170_p.func_72805_g(i, j - 1, k);
            return j > 62 && (block == Blocks.field_150349_c || block == Blocks.field_150346_d);
        }
        return false;
    }

    @Override
    public float func_70783_a(int i, int j, int k) {
        float f = 0.0f;
        BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
        if (this.isTreeHomeBiome(biome)) {
            f += 20.0f;
        }
        return f;
    }

    protected boolean isTreeHomeBiome(BiomeGenBase biome) {
        return biome instanceof LOTRBiomeGenFangorn;
    }

    @Override
    public boolean canReEquipHired(int slot, ItemStack itemstack) {
        return false;
    }
}

